//=============================================================================
// AmmoShell.
//=============================================================================
class MSMassEffectSummonMutator extends Mutator;

function PostBeginPlay()
{   
	Level.Game.BaseMutator.AddMutator(Self);
	Level.Game.RegisterDamageMutator(Self);
	
	if (AutoRecipient() != None) GiveStuff(class'PartsBag', AutoRecipient(), 1);
}

function PlayerPawn AutoRecipient()
{
 local PlayerPawn P, Pick;
 
 forEach AllActors(class'PlayerPawn', P)
 {
  if (P != None && DeusExPlayer(P).FindInventoryType(class'PartsBag') == None)
  {
   Pick = P;
  }
 }
 
 return Pick;
}

simulated function ShowMessage(DeusExPlayer Player, string Message)
{
  local HUDMissionStartTextDisplay    HUD;

  if ((Player.RootWindow != None) && (DeusExRootWindow(Player.RootWindow).HUD != None))
  {
    HUD = DeusExRootWindow(Player.RootWindow).HUD.startDisplay;
  }
  if(HUD != None)
  {
    HUD.shadowDist = 0;
    HUD.Message = "";
    HUD.charIndex = 0;
    HUD.winText.SetText("");
    HUD.winTextShadow.SetText("");
    HUD.displayTime = 5.50;
    HUD.perCharDelay = 0.30;
    HUD.AddMessage(Message);
    HUD.StartMessage();
  }
}

function GiveStuff(class<Actor> AType, PlayerPawn P, int Quantity)
{
 local Actor A;
 local int i;
 
 for(i=0; i<Quantity; i++)
 {
  A = Spawn(AType,,,P.Location);
  A.Frob(P, None);
 }
}

function Mutate(string S, PlayerPawn P)
{
 local DeusExMPGame A;
 local int i, j;
 local string STrim;
 
 if (S ~= "RifleParts")
 { 
  /*P.ConsoleCommand("Summon MSMassEffect.AK47Barrel");
  P.ConsoleCommand("Summon MSMassEffect.M16Barrel");
  P.ConsoleCommand("Summon MSMassEffect.G3Barrel");
  P.ConsoleCommand("Summon MSMassEffect.M60Barrel");

  P.ConsoleCommand("Summon MSMassEffect.IronBody");
  P.ConsoleCommand("Summon MSMassEffect.SteelBody");
  P.ConsoleCommand("Summon MSMassEffect.CarbonFiberBody");
  P.ConsoleCommand("Summon MSMassEffect.TitaniumBody");

  P.ConsoleCommand("Summon MSMassEffect.SemiFirePin");
  P.ConsoleCommand("Summon MSMassEffect.SemiAutoFirePin");
  P.ConsoleCommand("Summon MSMassEffect.SemiBurstFirePin");

  P.ConsoleCommand("Summon MSMassEffect.Mag10Shot");
  P.ConsoleCommand("Summon MSMassEffect.Mag20Shot");
  P.ConsoleCommand("Summon MSMassEffect.Mag30Shot");
  P.ConsoleCommand("Summon MSMassEffect.Mag100Shot");

  P.ConsoleCommand("Summon MSMassEffect.WoodStock");
  P.ConsoleCommand("Summon MSMassEffect.M16Stock");
  P.ConsoleCommand("Summon MSMassEffect.FoldingStock");
  P.ConsoleCommand("Summon MSMassEffect.CollapsibleStock");*/
  
  GiveStuff(class'AK47Barrel', P, 1);
  GiveStuff(class'M16Barrel', P, 1);
  GiveStuff(class'G3Barrel', P, 1);
  GiveStuff(class'M60Barrel', P, 1);

  GiveStuff(class'IronBody', P, 1);
  GiveStuff(class'SteelBody', P, 1);
  GiveStuff(class'CarbonFiberBody', P, 1);
  GiveStuff(class'TitaniumBody', P, 1);

  GiveStuff(class'SemiFirePin', P, 1);
  GiveStuff(class'SemiAutoFirePin', P, 1);
  GiveStuff(class'SemiBurstFirePin', P, 1);

  GiveStuff(class'Mag10Shot', P, 1);
  GiveStuff(class'Mag20Shot', P, 1);
  GiveStuff(class'Mag30Shot', P, 1);
  GiveStuff(class'Mag100Shot', P, 1);

  GiveStuff(class'WoodStock', P, 1);
  GiveStuff(class'M16Stock', P, 1);
  GiveStuff(class'FoldingStock', P, 1);
  GiveStuff(class'CollapsibleStock', P, 1);
 }
 if (S ~= "RifleAmmo")
 {  
  /*P.ConsoleCommand("Summon MSMassEffect.GunPowder");
  P.ConsoleCommand("Summon MSMassEffect.ExplosivePowder");
  P.ConsoleCommand("Summon MSMassEffect.IncindiaryPowder");

  P.ConsoleCommand("Summon MSMassEffect.RifleCasing50");
  P.ConsoleCommand("Summon MSMassEffect.RifleCasing762");
  P.ConsoleCommand("Summon MSMassEffect.RifleCasing556");

  P.ConsoleCommand("Summon MSMassEffect.APRifleTipping");
  P.ConsoleCommand("Summon MSMassEffect.HPRifleTipping");
  P.ConsoleCommand("Summon MSMassEffect.StandardRifleTipping");*/
  
  GiveStuff(class'GunPowder', P, 10);
  GiveStuff(class'ExplosivePowder', P, 10);
  GiveStuff(class'IncindiaryPowder', P, 10);

  GiveStuff(class'RifleCasing50', P, 30);
  GiveStuff(class'RifleCasing556', P, 30);
  GiveStuff(class'RifleCasing762', P, 30);

  GiveStuff(class'APRifleTipping', P, 10);
  GiveStuff(class'HPRifleTipping', P, 10);
  GiveStuff(class'StandardRifleTipping', P, 10);
 }

 if (S ~= "TestRifle")
 {
  P.ConsoleCommand("Summon MSMassEffect.CustomRifle");

  P.ConsoleCommand("Set CustomRifle CurBarrelDurability 999");
  P.ConsoleCommand("Set CustomRifle CurBodyDurability 999");
  P.ConsoleCommand("Set CustomRifle CurPinDurability 999");
  P.ConsoleCommand("Set CustomRifle CurFeedDurability 999");
  P.ConsoleCommand("Set CustomRifle CurStockDurability 999");

  P.ConsoleCommand("Set CustomRifle bHasBurst True");
  P.ConsoleCommand("Set CustomRifle bHasStock True");
  P.ConsoleCommand("Set CustomRifle bHasFeed True");
 }
 
 
 Super.Mutate(S, P);
}

defaultproperties
{
}
